package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 销售新老状态
 *
 * @author xiaotian
 * @date 2024/1/31 5:30 下午
 */
@Getter
@AllArgsConstructor
public enum OtoSellerOldEnum {

    /**
     * 老销售
     */
    OLD(1, "老销售"),

    /**
     * 新销售
     */
    NEW(0, "新销售"),
    ;

    private static final Map<Integer, OtoSellerOldEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoSellerOldEnum::getSellerOld, Function.identity(), (v1, v2) -> v1)));
    private Integer sellerOld;
    private String desc;

    public static OtoSellerOldEnum getBySellerOld(Integer sellerOld) {
        if (Objects.isNull(sellerOld)) {
            return null;
        }

        return ENUM_MAP.get(sellerOld);
    }

}
