package cn.com.duiba.oto.enums.pet;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 开门方式
 * 开门方式：1=密码锁，2=存放快递柜，3=家中有人，4=其他
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum PetDoorTypeEnum {
    /**
     * 密码锁
     */
    PASSWORD_LOCK(1, "密码锁"),
    /**
     * 存放快递柜
     */
    EXPRESS_CABINET(2, "存放快递柜"),
    /**
     * 家中有人
     */
    HOME_PERSON(3, "家中有人"),
    /**
     * 其他
     */
    OTHER(4, "其他"),
    /**
     * 物业对接
     */
    PROPERTY_DOCKET(5, "物业对接"),
    ;

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(PetDoorTypeEnum::getCode, PetDoorTypeEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }
}
