package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.OfficialAccountsDto;

/**
 * @author xiaotian
 * @date 2023/01/28
 */
@AdvancedFeignClient
public interface RemoteOfficialAccountService {

    /**
     * 根据id,获取配置
     * (本地缓存)
     */
    OfficialAccountsDto selectByOaId(Long oaId);

    /**
     * 根据小程序appid,获取配置
     * (本地缓存)
     */
    OfficialAccountsDto selectByAppId(String appId);

    /**
     * 根据sourceId,获取配置
     * (本地缓存)
     */
    OfficialAccountsDto selectBySourceId(String sourceId);

    /**
     * 根据类型获取信息
     * @param oaType
     * @see cn.com.duiba.oto.enums.wx.OtoOATypeEnum
     * @return
     */
    OfficialAccountsDto selectByOaType(Integer oaType);
}
