package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 收入业绩数据DTO
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BoardIncomeDataDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 月份，例如 2025-09
     */
    private String month;

    /**
     * 销售ID
     */
    private Long sellerId;

    /**
     * 当月业绩
     */
    private BigDecimal performance;

    /**
     * 当月收入
     */
    private BigDecimal income;

    /**
     * 累计业绩（年度完整自然月）
     */
    private BigDecimal cumulativePerformance;

    /**
     * 累计收入（年度完整自然月）
     */
    private BigDecimal cumulativeIncome;
}

