package cn.com.duiba.oto.dto.oto.board;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经营池数据表格DTO
 * 继承BoardTableDto，并添加列分组信息
 *
 * @author xiaotian
 * @date 2025-01-27
 */
@Data
public class BusinessPoolTableDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 表格列信息列表
     * 第一列固定为"分组"，后续列为各个指标名称及其描述
     * 每个列对象包含其所属的分组名称（groupName字段）
     */
    private List<BoardTableColumnDto> columns;

    /**
     * 表格行数据列表
     * 包含分组行和总计行
     */
    private List<BoardTableRowDto> rows;

    /**
     * 数据最新更新时间
     * 取数据库中查询结果的最新的gmt_create时间
     */
    private Date updateTime;
}

