package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户关键信息DTO
 *
 * @author xiaotian
 * @date 2024-12-18
 */
@Data
public class CustomerInfoDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 是否高潜客户：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.HighPotentialEnum}
     */
    private Integer highPotential;

    /**
     * 家庭结构
     */
    private String familyStructure;

    /**
     * 是否买过保险：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.HasInsuranceEnum}
     */
    private Integer hasInsurance;

    /**
     * 是否抗保：0=否，1=是
     * {@link cn.com.duiba.oto.enums.cust.info.AntiGuaranteeEnum}
     */
    private Integer antiGuarantee;

    /**
     * 现金流情况（1:50w以下 2:50w-100w 3:100w-200w 4:200w以上）
     * {@link cn.com.duiba.oto.enums.cust.info.CashFlowEnum}
     */
    private Integer cashFlow;

    /**
     * 不动产情况
     */
    private String realEstate;

    /**
     * 退休金
     */
    private String pension;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
