package cn.com.duiba.oto.dto.oto.deal;

import com.alibaba.fastjson.JSON;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 成交保单表
 *
 * @TableName tb_oto_deal_order
 */
@Data
public class DealOrderDto implements Serializable {
    private static final long serialVersionUID = 8507703217735123171L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 客户id tb_oto_customer.id
     */
    private Long custId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 保单号
     */
    private String dealNo;

    /**
     * 基本信息
     */
    private String baseInfo;

    /**
     * 投保人信息
     */
    private String policyHolderInfo;

    /**
     * 被保人信息
     */
    private String insuredInfo;

    /**
     * 受益人信息
     */
    private String beneficiaryInfo;

    /**
     * 监护人信息
     */
    private String guardianInfo;

    /**
     * 承保时间
     */
    private Date coverTime;
    /**
     * 产品名称
     */
    private String productName;
    /**
     * 保险公司
     */
    private String insureCompany;
    /**
     * 保单状态
     */
    private Integer dealStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;


    public BaseInfoDto getBaseInfoDto() {
        return JSON.parseObject(this.baseInfo, BaseInfoDto.class);
    }

    public InsuredInfoDto getInsuredInfoDto() {
        return JSON.parseObject(this.insuredInfo, InsuredInfoDto.class);
    }

    public BeneficiaryInfoDto getBeneficiaryInfoDto() {
        return JSON.parseObject(this.beneficiaryInfo, BeneficiaryInfoDto.class);
    }

    public GuardianInfoDto getGuardianInfoDto() {
        return JSON.parseObject(this.guardianInfo, GuardianInfoDto.class);
    }


    public PolicyHolderInfoDto getPolicyHolderInfoDto() {
        return JSON.parseObject(this.policyHolderInfo, PolicyHolderInfoDto.class);
    }


    /**
     * 基本信息
     */
    @Data
    public static class BaseInfoDto implements Serializable {

        private static final long serialVersionUID = 5536243102795451723L;

        /**
         * 保单号
         */
        private String dealNo;

        /**
         * 投保单号
         */
        private String insureNo;

        /**
         * 保险公司
         */
        private String insureCompany;

        /**
         * 险种
         */
        private String insureType;

        /**
         * 产品名称
         */
        private String productName;

        /**
         * 出单工号
         */
        private String underwriteNo;

        /**
         * 专家Id
         */
        private Long expertId;

        /**
         * 专家名字
         */
        private Long expertName;

        /**
         * 签担保费
         */
        private String writtenPremium;

        /**
         * 缴费年期
         */
        private String paymentPeriod;

        /**
         * 缴费方式(年交/月交/季度交)
         */
        private Integer paymentMethod;

        /**
         * 保额
         */
        private String insuredAmount;

        /**
         * 保单状态
         */
        private Integer dealStatus;

        /**
         * 标保
         */
        private String normalGuarantee;

        /**
         * 价保
         */
        private String priceGuarantee;

        /**
         * 投保日期
         */
        private String underwriteTime;

        /**
         * 承保时间
         */
        private String coverTime;

        /**
         * 回执时间
         */
        private String receiptTime;

        /**
         * 回访时间
         */
        private String visitTime;

    }


    /**
     * 投保人信息
     */
    @Data
    public static class PolicyHolderInfoDto implements Serializable {

        private static final long serialVersionUID = -7273130250212312845L;

        /**
         * 投保人姓名
         */
        private String policyHolderName;

        /**
         * 投保人Id
         */
        private String policyHolderId;

        /**
         * 投保人证件类型
         * 居民身份证、护照、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国人居留证、其他身份证件
         * 提交后不可更改；
         */
        private String policyHolderCertType;

        /**
         * 投保人证件号码
         * 根据证件类型限制具体位数；
         */
        private String policyHolderCertNo;

        /**
         * 证件有效期：可选择年月日，需要选择起止日期，必填，提交后不可更改；
         */
        private String policyHolderCertValidity;

        /**
         * 投保人性别：下拉选项，必填，选项为“男/女”，若系统存在数据，则自动带出；
         */
        private String policyHolderSex;

        /**
         * 投保人周岁：不可填写，根据投保人出生日期自动计算；
         */
        private Integer policyHolderAge;

        /**
         * 投保人出生日期：可选择年月日，必填，若系统存在数据，则自动带出，并且带出后需要变更投保人周岁；
         */
        private String policyHolderBirthday;

        /**
         * 投保人联系电话：手机号输入，限制11位，若系统存在数据，则自动带出；
         */
        private String policyHolderPhone;

        /**
         * 投保人联系地址：文字输入，限制30位，若系统存在数据，则自动带出；
         */
        private String policyHolderAddress;

        /**
         * 投保人银行名称：文字输入，限制30位；
         */
        private String policyHolderBankName;

        /**
         * 投保人银行卡号：数字输入，限制30位；
         */
        private String policyHolderBankNo;
    }

    /**
     * 被保人信息
     */
    @Data
    public static class InsuredInfoDto implements Serializable {

        private static final long serialVersionUID = -7427772657906392539L;

        /**
         * 被保人是否为投保人：必填，默认为“是”，若选中为“否”，则展示被保人身份信息填写，注意如果选择“是”的情况下，虽然前端隐藏但是字段需要正常存储，以被保人和投保人相同保存；
         */
        private String insuredIsPolicyHolder = "是";

        /**
         * a. 被保人姓名：可输入文字或数字，必填，限制30字；
         */
        private String insuredName;

        /**
         * 被保人证件类型：下拉选项，单选，必填，选项为“居民身份证、护照、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国人居留证、其他身份证件”，提交后不可更改；
         */
        private String insuredCertType;

        /**
         * 被保人证件号码：可输入字母或数字，必填，根据证件类型限制具体位数；
         */
        private String insuredCertNo;

        /**
         * 被保人证件有效期：可选择年月日，需要选择起止日期，必填，提交后不可更改；
         */
        private String insuredCertValidity;

        /**
         * 被保人性别：下拉选项，必填，选项为“男/女”；
         */
        private String insuredSex;

        /**
         * 被保人联系电话：手机号输入，限制11位；
         */
        private String insuredPhone;

        /**
         * 被保人联系地址：文字输入，限制30位；
         */
        private String insuredAddress;

    }


    /**
     * 受益人信息
     */
    @Data
    public static class BeneficiaryInfoDto implements Serializable {

        private static final long serialVersionUID = -7427772657906392539L;

        /**
         * 受益人是否为法定：必填，默认为“是”，若选中为“否”，则展示受益人身份信息填写；
         */
        private String beneficiaryIsLegal = "是";

        /**
         * 受益人姓名：可输入文字或数字，必填，限制30字；
         */
        private String beneficiaryName;

        /**
         * 受益人证件类型：下拉选项，单选，必填，选项为“居民身份证、护照、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国人居留证、其他身份证件”，提交后不可更改；
         */
        private String beneficiaryCertType;

        /**
         * 受益人证件号码：可输入字母或数字，必填，根据证件类型限制具体位数；
         */
        private String beneficiaryCertNo;

        /**
         * 与投保人关系：下拉选项，必填，选项为“配偶、父母、子女、旁系亲属、其他”；
         */
        private String beneficiaryRelation;

    }


    /**
     * 监护人信息
     */
    @Data
    public static class GuardianInfoDto implements Serializable {
        private static final long serialVersionUID = -7427772657906392539L;

        /**
         * 是否存在监护人：必填，默认为“否”，若选中为“是”，则展示监护人身份信息填写；
         */
        private String guardianIsExist = "否";
        /**
         * 监护人姓名：可输入文字或数字，必填，限制30字；
         */
        private String guardianName;
        /**
         * 监护人证件类型：下拉选项，单选，必填，选项为“居民身份证、护照、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国人居留证、其他身份证件”，提交后不可更改；
         */
        private String guardianCertType;
        /**
         * 监护人证件号码：可输入字母或数字，必填，根据证件类型限制具体位数；
         */
        private String guardianCertNo;
        /**
         * 与投保人关系：下拉选项，必填，选项为“配偶、父母、子女、旁系亲属、其他”；
         */
        private String guardianRelation;
    }


}