package cn.com.duiba.oto.dto.oto.wxwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企微消息记录信息表
 *
 * @author kjj mybatis generator
 * @date 2022-10-08
 */
@Data
public class YunkeMsgDto implements Serializable {

    private static final long serialVersionUID = 16651976943873692L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 会话ID=内部wxId+外部wxId 如果是群聊=roomid
     */
    private String chatId;

    /**
     * 消息ID,消息的唯一标识,用此字段进行消息去重
     */
    private String msgId;

    /**
     * 消息发送方wxId
     */
    private String fromWxId;

    /**
     * 消息接收方（集合）
     */
    private String receiveWxId;

    /**
     * 群聊消息的群id
     */
    private String roomid;

    /**
     * 消息发送，utc时间，ms单位
     */
    private Date msgtime;

    /**
     * 消息类型：1聊天文本, 2图片，3语音消息，4视频消息，9文件，10链接，14定位信息，18小程序
     */
    private String msgtype;

    /**
     * 会话类型 1 内部单聊 2 内部群聊 3 外部单聊 4 外部群聊
     */
    private Integer convType;

    /**
     * 消息内容（只存会话消息） 如果是图片，则该字段为空
     */
    private String content;

    /**
     * 消息内容(json格式 ，比如消息内容为图片，存储图片的大小等参数)
     */
    private String contentJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 消息发送方名字
     */
    private String fromUserName;

    /**
     * 消息接受方名字
     */
    private String reveiveUserName;

    /**
     * 群聊消息群名称
     */
    private String roomName;

}