/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum PetServiceTypeEnum {
    FEEDING(1, "\u4e0a\u95e8\u5582\u517b"),
    WASH(2, "\u4e0a\u95e8\u6d17\u62a4");

    private static final Map<Integer, String> CUSTOMER_TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return CUSTOMER_TYPE_MAP.get(code);
    }

    public static PetServiceTypeEnum getByCode(Integer code) {
        for (PetServiceTypeEnum value : PetServiceTypeEnum.values()) {
            if (!value.getCode().equals(code)) continue;
            return value;
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private PetServiceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        CUSTOMER_TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(PetServiceTypeEnum.values()).collect(Collectors.toMap(PetServiceTypeEnum::getCode, PetServiceTypeEnum::getDesc, (v1, v2) -> v1)));
    }
}

