package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * OTO-客户列表分页查询参数
 *
 * @author ZhangJun
 * @date 2022/1/5 7:38 下午
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustPageParam extends PageQuery {

    private static final long serialVersionUID = 4378618085361525345L;

    /**
     * 搜索客户名称
     */
    private String custName;
    /**
     * 客户手机号
     */
    private String phoneNum;

    /**
     * 分配状态,0-待分配，1-已分配
     */
    private Integer assignStatus;

    /**
     * 客户价值
     */
    private List<Integer> custValueList;

    /**
     * id主键
     */
    private List<Long> idList;

    /**
     * 所属保险公司id
     */
    private Long companyId;

    /**
     * 所处资源池类型
     *
     */
    private List<Integer> poolTypes;

    /**
     * 客户来源
     */
    private Integer custSource;

    /**
     * 销售id排序扰动因子
     */
    private Long modNum;

    /**
     * 需要过滤的客户
     */
    private List<Long> notInCustIds;

    /**
     * 客户来源
     */
    private List<String> custFromSourceList;

    /**
     * 起始创建时间
     */
    private Date createBeginTime;

    /**
     * 结束创建时间
     */
    private Date createEndTime;

    /**
     * 客户所在省市区
     */
    private List<String> custAreas;

    /**
     * 专家id
     */
    private Long expertSellerId;

    /**
     * 手机号归属地
     */
    private String custArea;
}
