package cn.com.duiba.oto.enums.cust;

/**
 * Created by xiaotian on 2019-06-24.
 * <p>
 * 为了代码review更方便，以及冲突解决的问题，enum的name请尽量声明的有意义，在合并代码时，
 * <p>
 * ！most important 请注意key，不要和别人冲突了。
 */
public enum RedisKeyFactoryCopyKjyManager {

    OTO_CUST_OPT_KEY("063", "OTO-客户操作分布式锁"),
    OTO_SELLER_OPT_KEY("064", "OTO-销售操作分布式锁"),
    OTO_FEEDBACK_INTERVIEW("065", "OTO-销售操作分布式锁"),
    ;


    RedisKeyFactoryCopyKjyManager(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    private String key;
    private String desc;

    private static final String SPACE = "KjyManage";
    private static final String SEPARATOR = "_";

    /**
     * 需要追加参数作为key时使用，参数会以SEPARATOR隔开
     *
     * @param args
     * @return
     */
    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg : args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 直接返回拼装后完整的key
     *
     * @return
     */
    @Override
    public String toString() {
        return SPACE + SEPARATOR + this.key;
    }

    public String getDesc() {
        return desc;
    }
}
