package cn.com.duiba.oto.enums.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-客户管理添加微信枚举
 *
 * @author xiaocong
 * @date 2021/11/17 7:28 下午
 */
@Getter
@AllArgsConstructor
public enum PubFormCustomerAddWeChatEnum {

    /**
     * 未加微信
     */
    UN_ADD(0, "否"),

    /**
     * 已加
     */
    ADD(1, "是");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> ADD_WE_CHAT_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerAddWeChatEnum::getCode, PubFormCustomerAddWeChatEnum::getDescription));
        ADD_WE_CHAT_MAP = Collections.unmodifiableMap(map);
    }
}
