package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum KycStatusEnum {

    NOT_UPLOAD(0, "未上传"),
    QUALIFIED(1, "合格"),
    NOT_QUALIFIED(2, "不合格"),
    UPLOAD_NO_QUALIFIED(3, "已上传无状态"),
    ;

    private static final Map<Integer, KycStatusEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(KycStatusEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    KycStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static KycStatusEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
