package cn.com.duiba.oto.enums.deal;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 成单类别（1:正常单 2:孤儿单）
 */
@Getter
public enum DealTypeEnum {

    NORMAL(1, "正常单"),
    ORPHAN(2, "孤儿单"),
    ;

    private static final Map<Integer, DealTypeEnum> INNER_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(DealTypeEnum::getCode, Function.identity(), (v1, v2) -> v1))
    );

    private final Integer code;
    private final String desc;

    DealTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DealTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        final DealTypeEnum type = INNER_MAP.get(code);
        return type == null ? null : type.getDesc();
    }
}


