package cn.com.duiba.oto.param.oto.call;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 功能描述：通话记录查询参数
 *
 * @Auther: xiaotian
 * @Date: 2025/03/06 14:52
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CallLogSearchParam extends PageQuery {

    private static final long serialVersionUID = -552472208963182225L;

    /**
     * 客户开始时间
     */
    private Date startTime;

    /**
     * 客户结束时间
     */
    private Date endTime;

    /**
     * 专家ID
     */
    private List<Long> sellerIds;

    /**
     * 客户id
     */
    private List<Long> custIds;

    /**
     * 额外参数
     */
    private String extraParams;
}
