/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.result.PayChargeResult;
import cn.com.duiba.paycenter.service.DuibaPayChargeService;
import cn.com.duiba.paycenter.util.SignUtil;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.HashMap;

public class DuibaPayChargeServiceClient {
    private DuibaPayChargeService duibaPayChargeService;

    public RpcResult<PayChargeResult> chargeMoneyByManual(Long manualApplyId, Long money) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("relationId", manualApplyId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayChargeResult ret = this.duibaPayChargeService.chargeMoneyByManual(manualApplyId, money, sign);
            RpcResult<PayChargeResult> result = new RpcResult<PayChargeResult>(ret);
            return result;
        }
        catch (RpcException e) {
            RpcResult<PayChargeResult> result = new RpcResult<PayChargeResult>(e);
            return result;
        }
    }

    public RpcResult<PayChargeResult> reduceMoneyByManual(Long manualApplyId, Long money) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("relationId", manualApplyId + "");
            params.put("money", money + "");
            String sign = SignUtil.sign(params);
            PayChargeResult ret = this.duibaPayChargeService.reduceMoneyByManual(manualApplyId, money, sign);
            RpcResult<PayChargeResult> result = new RpcResult<PayChargeResult>(ret);
            return result;
        }
        catch (RpcException e) {
            RpcResult<PayChargeResult> result = new RpcResult<PayChargeResult>(e);
            return result;
        }
    }

    public void setDuibaPayChargeService(DuibaPayChargeService duibaPayChargeService) {
        this.duibaPayChargeService = duibaPayChargeService;
    }
}

