package cn.com.duiba.paycenter.dto.payment.refund;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author zhangruofan
 * @date 2018/11/27
 */
public class RefundRequest implements Serializable {

    private static final long serialVersionUID = -1721185925672482225L;
    /**
     * 支付订单id
     */
    @NotNull(message = "支付订单号不能为空")
    private String chargeOrderNo;
    /**
     * 需要退款的金额，必须小于支付金额
     * 单位为分
     */
    @NotNull(message = "退款金额不能为空")
    @Min(value = 1, message = "最少退款一分钱")
    private Integer amount;
    @Size(max = 255, message = "extra最长255")
    private String extra;
    @Size(max = 255, message = "description最长255")
    private String description;

    public String getExtra() {
        return extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getChargeOrderNo() {
        return chargeOrderNo;
    }

    public void setChargeOrderNo(String chargeOrderNo) {
        this.chargeOrderNo = chargeOrderNo;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }
}
