package cn.com.duiba.paycenter.enums;

/**
 * 支付中心分配的业务方类型
 * @author zhangruofan
 * @date 2018/11/12
 */
public enum BizTypeEnum {

    /**
     * 订单支付
     */
    ORD(1),

    /**
     * 充值支付
     */
    RCG(2),
    /**
     * 客集集
     */
    KJJ(3)
    ;

    private Integer code;

    BizTypeEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static BizTypeEnum getBizTypeEnumByCode(Integer code) {
        for (BizTypeEnum bizTypeEnum : BizTypeEnum.values()) {
            if (bizTypeEnum.getCode().equals(code)) {
                return bizTypeEnum;
            }
        }
        return null;
    }
}

