package cn.com.duiba.paycenter.params;

import cn.com.duiba.paycenter.enums.PayAccountTypeEnum;
import cn.com.duiba.paycenter.enums.PayOrderBizTypeEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 资金转账请求
 * Created by xiaoxuda on 2017/11/1.
 */
public class FundTransferRequestParams implements Serializable {
    private static final long serialVersionUID = -8286934799512512845L;

    /**
     * 业务标识
     **/
    @NotNull(message = "业务标识不能为null")
    private PayOrderBizTypeEnum bizType;
    /**
     * 业务方的业务唯一编号
     **/
    @NotBlank(message = "业务编号不能为空")
    private String bizNo;
    /**
     * 支付金额，单位分
     **/
    @NotNull(message = "金额不能为null")
    private Long amount;
    /**
     * 收款账号类型
     **/
    @NotNull(message = "收款账号类型不能为null")
    private PayAccountTypeEnum payeeType;
    /**
     * 收款账号
     **/
    @NotBlank(message = "收款账号不能为空")
    private String payeeNo;
    /**
     * 收款账户姓名
     **/
    @NotBlank(message = "收款账户姓名不能为空")
    private String payeeName;
    /**
     * 转账备注
     */
    private String remark;

    public PayOrderBizTypeEnum getBizType() {
        return bizType;
    }

    public void setBizType(PayOrderBizTypeEnum bizType) {
        this.bizType = bizType;
    }

    public String getBizNo() {
        return bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public Long getAmount() {
        return amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public PayAccountTypeEnum getPayeeType() {
        return payeeType;
    }

    public void setPayeeType(PayAccountTypeEnum payeeType) {
        this.payeeType = payeeType;
    }

    public String getPayeeNo() {
        return payeeNo;
    }

    public void setPayeeNo(String payeeNo) {
        this.payeeNo = payeeNo;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
