package cn.com.duiba.paycenter.dto.payment.charge.alipay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author zhangruofan
 * @date 2018/12/17
 */
public class AlipayNativeChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -7495209060315482888L;
    @Size(max = 255, message = "returnUrl不能超过255")
    private String returnUrl;
    /**
     * 商品的标题/交易标题/订单标题/订单关键字等。
     */
    @NotNull(message = "支付标题必填")
    @Size(max = 255, message = "支付标题最多255")
    private String subject;
    /**
     * 对一笔交易的具体描述信息。
     */
    @Size(max = 128, message = "body不能超过128")
    private String body;

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}
