package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;
import cn.com.duiba.paycenter.enums.ChannelEnum;
import cn.com.duiba.paycenter.validator.MinExpireTime;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/11/20
 */
public class WxPayWapChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -7600097406056508311L;
    /**
     * 客户端ip地址
     * 获取用户真实ip
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5_sl.php?chapter=15_5
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String clientIp;
    /**
     * 订单标题
     * 会传给第三方支付
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;

    /**
     * 交易结束时间
     */
    @MinExpireTime
    private Date timeExpire;

    /**
     * 场景信息
     * {"h5_info": //h5支付固定传"h5_info"
     *    {"type": "",  //场景类型
     *     "wap_url": "",//WAP网站URL地址
     *     "wap_name": ""  //WAP 网站名
     *     }
     * }
     */
    @Size(max = 256)
    private String sceneInfo;

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Date getTimeExpire() {
        return timeExpire;
    }

    public void setTimeExpire(Date timeExpire) {
        this.timeExpire = timeExpire;
    }

    public String getSceneInfo() {
        return sceneInfo;
    }

    public void setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
    }

    @Override
    public String getChannelType() {
        return ChannelEnum.WX_WAP.getChannelType();
    }
}
