package cn.com.duiba.paycenter.dto.payment.refund.alipay;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author zhangruofan
 * @date 2018/12/11
 */
public class AlipayRefundRequest implements Serializable {
    private static final long serialVersionUID = -7596164774298980785L;
    /**
     * 退款金额
     */
    @NotNull(message = "金额不能为空")
    @Min(value = 1, message = "金额必须大于1分")
    private Integer amount;
    /**
     * 支付订单号/主订单号
     * 为了兼容老api发起的支付请求
     * 需要判断如果不是ORD开头的则直接退款
     */
    @NotNull(message = "支付订单号不能为空")
    private String chargeOrderNo;

    @NotNull(message = "兑吧appid不能为空")
    private Long appId;
    /**
     * 支付宝流水
     */
    @NotNull(message = "支付宝流水号不能为空")
    private String tradeNo;

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getChargeOrderNo() {
        return chargeOrderNo;
    }

    public void setChargeOrderNo(String chargeOrderNo) {
        this.chargeOrderNo = chargeOrderNo;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getTradeNo() {
        return tradeNo;
    }

    public void setTradeNo(String tradeNo) {
        this.tradeNo = tradeNo;
    }
}
