package cn.com.duiba.paycenter.enums;

/**
 * 渠道配置之模式
 * 兑吧代收，使用兑吧的渠道账户
 * 自主模式，使用开发者自己的渠道账户
 * @author zhangruofan
 * @date 2018/11/06
 */
public enum ChannelModeEnum {
    DUIBA(1, "兑吧代收"),
    INDEPENDENT(2, "自主模式")
    ;
    private Integer code;
    private String desc;

    ChannelModeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
