/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.AppAccountPayChargeParams;
import cn.com.duiba.paycenter.params.PayChargeExtraParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountPayChargeService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;

public class AppPayChargeServiceClient {
    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountPayChargeService remoteAppAccountPayChargeService;

    public RpcResult<PayCenterResult> chargeMoneyByManual(Long developerId, Long appId, Long manualApplyId, Long money, PayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, developerId + "");
            params.put(RELATION_ID, manualApplyId + "");
            params.put(MONEY, money + "");
            params.put(APP_ID, appId + "");
            String sign = SignUtil.sign(params);
            AppAccountPayChargeParams payChargeParams = new AppAccountPayChargeParams();
            payChargeParams.setAppId(appId);
            payChargeParams.setChangeMoney(money);
            payChargeParams.setDeveloperId(developerId);
            payChargeParams.setRelationId(Objects.toString(manualApplyId));
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByManual(payChargeParams, sign, p);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyByOnline(Long developerId, Long appId, Long onlineApplyId, Long money, PayChargeExtraParams p) {
        try {
            String sign = this.getSign(developerId, appId, onlineApplyId, money);
            AppAccountPayChargeParams payChargeParams = new AppAccountPayChargeParams();
            payChargeParams.setAppId(appId);
            payChargeParams.setChangeMoney(money);
            payChargeParams.setDeveloperId(developerId);
            payChargeParams.setRelationId(Objects.toString(onlineApplyId));
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByOnline(payChargeParams, sign, p);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> reduceMoneyByManual(Long developerId, Long appId, Long manualApplyId, Long money, PayChargeExtraParams p) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, developerId + "");
            params.put(RELATION_ID, manualApplyId + "");
            params.put(MONEY, money + "");
            params.put(APP_ID, appId + "");
            String sign = SignUtil.sign(params);
            AppAccountPayChargeParams payChargeParams = new AppAccountPayChargeParams();
            payChargeParams.setAppId(appId);
            payChargeParams.setChangeMoney(money);
            payChargeParams.setDeveloperId(developerId);
            payChargeParams.setRelationId(Objects.toString(manualApplyId));
            PayCenterResult ret = this.remoteAppAccountPayChargeService.reduceMoneyByManual(payChargeParams, sign, p);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyFeeByOnline(Long developerId, Long appId, Long onlineApplyId, Long fee, PayChargeExtraParams p) {
        try {
            String sign = this.getSign(developerId, appId, onlineApplyId, fee);
            AppAccountPayChargeParams payChargeParams = new AppAccountPayChargeParams();
            payChargeParams.setAppId(appId);
            payChargeParams.setChangeMoney(fee);
            payChargeParams.setDeveloperId(developerId);
            payChargeParams.setRelationId(Objects.toString(onlineApplyId));
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyFeeByOnline(payChargeParams, sign, p);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    private String getSign(Long developerId, Long appId, Long onlineApplyId, Long money) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVELOPER_ID, developerId + "");
        params.put(RELATION_ID, onlineApplyId + "");
        params.put(MONEY, money + "");
        params.put(APP_ID, appId + "");
        return SignUtil.sign(params);
    }
}

