/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.DuibaAccountChangeParam;
import cn.com.duiba.paycenter.remoteservice.RemoteDuibaIncomeAccountService;
import cn.com.duiba.paycenter.result.PayChargeResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import javax.annotation.Resource;

public class DuibaIncomeServiceClient {
    @Resource
    private RemoteDuibaIncomeAccountService remoteDuibaIncomeAccountService;

    public RpcResult<PayChargeResult> addIncome(DuibaAccountChangeParam param) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("relationId", param.getRelationId() + "");
            params.put("money", param.getChangeMoney() + "");
            params.put("type", param.getActionType().getCode() + "");
            String sign = SignUtil.sign(params);
            param.setSign(sign);
            PayChargeResult ret = this.remoteDuibaIncomeAccountService.addIncome(param);
            return new RpcResult<PayChargeResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayChargeResult>(e);
        }
    }

    public RpcResult<PayChargeResult> paybackIncome(DuibaAccountChangeParam param) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("relationId", param.getRelationId() + "");
            params.put("money", param.getChangeMoney() + "");
            params.put("type", param.getActionType().getCode() + "");
            String sign = SignUtil.sign(params);
            param.setSign(sign);
            PayChargeResult ret = this.remoteDuibaIncomeAccountService.paybackIncome(param);
            return new RpcResult<PayChargeResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayChargeResult>(e);
        }
    }
}

