/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.validator.impl;

import cn.com.duiba.paycenter.validator.EnumCheck;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class EnumCheckConstraintValidator
implements ConstraintValidator<EnumCheck, Object> {
    private Object[] enumValueList;
    private String message;

    public void initialize(EnumCheck constraintAnnotation) {
        this.enumValueList = constraintAnnotation.value().getEnumConstants();
        this.message = constraintAnnotation.message();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        boolean contains;
        if (value == null) {
            return true;
        }
        if (this.enumValueList != null && this.enumValueList.length > 0 && (contains = Arrays.asList(this.enumValueList).contains(value))) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        ConstraintValidatorContext.ConstraintViolationBuilder builder = context.buildConstraintViolationWithTemplate(this.message);
        builder.addConstraintViolation();
        return false;
    }
}

