/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.AppAccountChangeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import javax.annotation.Resource;

public class AppAccountServiceClient {
    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountService remoteAppAccountService;

    public RpcResult<PayCenterResult> reduceMoney(AppAccountChangeParams param) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, param.getDeveloperId() + "");
            params.put(RELATION_ID, param.getRelationId() + "");
            params.put(MONEY, param.getMoney() + "");
            params.put(APP_ID, param.getAppId() + "");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = this.remoteAppAccountService.reduceMoney(param, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> addMoney(AppAccountChangeParams param) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, param.getDeveloperId() + "");
            params.put(RELATION_ID, param.getRelationId() + "");
            params.put(MONEY, param.getMoney() + "");
            params.put(APP_ID, param.getAppId() + "");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = this.remoteAppAccountService.addMoney(param, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }
}

