/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.client;

import cn.com.duiba.paycenter.client.RpcResult;
import cn.com.duiba.paycenter.params.AppAccountPayChargeParams;
import cn.com.duiba.paycenter.remoteservice.RemoteAppAccountPayChargeService;
import cn.com.duiba.paycenter.result.PayCenterResult;
import cn.com.duiba.paycenter.util.SignUtil;
import java.util.HashMap;
import javax.annotation.Resource;

public class AppPayChargeServiceClient {
    private static final String DEVELOPER_ID = "developerId";
    private static final String RELATION_ID = "relationId";
    private static final String MONEY = "money";
    private static final String APP_ID = "appId";
    @Resource
    private RemoteAppAccountPayChargeService remoteAppAccountPayChargeService;

    public RpcResult<PayCenterResult> chargeMoneyByManual(AppAccountPayChargeParams payChargeParams) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, payChargeParams.getDeveloperId() + "");
            params.put(RELATION_ID, payChargeParams.getRelationId() + "");
            params.put(MONEY, payChargeParams.getChangeMoney() + "");
            params.put(APP_ID, payChargeParams.getAppId() + "");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByManual(payChargeParams, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyByOnline(AppAccountPayChargeParams params) {
        try {
            String sign = this.getSign(params.getDeveloperId(), params.getAppId(), params.getRelationId(), params.getChangeMoney());
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyByOnline(params, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> reduceMoneyByManual(AppAccountPayChargeParams payChargeParams) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(DEVELOPER_ID, payChargeParams.getDeveloperId() + "");
            params.put(RELATION_ID, payChargeParams.getRelationId() + "");
            params.put(MONEY, payChargeParams.getChangeMoney() + "");
            params.put(APP_ID, payChargeParams.getAppId() + "");
            String sign = SignUtil.sign(params);
            PayCenterResult ret = this.remoteAppAccountPayChargeService.reduceMoneyByManual(payChargeParams, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    public RpcResult<PayCenterResult> chargeMoneyFeeByOnline(AppAccountPayChargeParams payChargeParams) {
        try {
            String sign = this.getSign(payChargeParams.getDeveloperId(), payChargeParams.getAppId(), payChargeParams.getRelationId(), payChargeParams.getChangeMoney());
            PayCenterResult ret = this.remoteAppAccountPayChargeService.chargeMoneyFeeByOnline(payChargeParams, sign);
            return new RpcResult<PayCenterResult>(ret);
        }
        catch (Exception e) {
            return new RpcResult<PayCenterResult>(e);
        }
    }

    private String getSign(Long developerId, Long appId, String onlineApplyId, Long money) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(DEVELOPER_ID, developerId + "");
        params.put(RELATION_ID, onlineApplyId + "");
        params.put(MONEY, money + "");
        params.put(APP_ID, appId + "");
        return SignUtil.sign(params);
    }
}

