package cn.com.duiba.paycenter.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * 支付渠道枚举
 * @author zhangruofan
 * @date 2018/11/05
 */
public enum ChannelEnum {
    /**
     * 支付宝APP支付
     */
    ALIPAY("alipay", "支付宝APP支付"),
    /**
     * 支付宝手机网站支付
     */
    ALIPAY_WAP("alipay_wap", "支付宝手机网站支付"),
    /**
     * 支付宝扫码支付
     */
    ALIPAY_QR("alipay_qr", "支付宝扫码支付"),
    /**
     * 微信APP支付
     */
    WX("wx", "微信APP支付"),
    /**
     * 微信公众号支付
     */
    WX_PUB("wx_pub", "微信公众号支付"),
    /**
     * 微信扫码支付
     */
    WX_PUB_QR("wx_pub_qr", "微信扫码支付"),
    /**
     * 微信H5支付
     */
    WX_WAP("wx_wap", "微信H5支付"),
    /**
     * 微信小程序支付
     */
    WX_LITE("wx_lite", "微信小程序支付"),
    /**
     * 连连个人支付
     */
    LIANLIAN_PERSONAL("lianlian_personal", "连连个人支付"),
    /**
     * 连连企业支付
     */
    LIANLIAN_ENTERPRISE("lianlian_enterprise", "连连企业支付");

    private String channelType;
    private String channelName;

    ChannelEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return channelType;
    }

    public String getChannelName() {
        return channelName;
    }

    public static String getChannelName(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return null;
        }
        if (isActive(channelType)) {
            return ChannelEnum.valueOf(channelType).channelName;
        }
        return null;
    }

    /**
     * 返回channelId是否有效
     * @param channelType 渠道
     * @return 是否有效
     */
    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return false;
        }
        return Arrays.stream(ChannelEnum.values())
                .anyMatch(channelEnum -> channelEnum.channelType.equals(channelType));
    }
}
