package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.ChargeOrderDto;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.alipay.AlipayWapChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayMpChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayMpChargeResponse;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayWapChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayWapChargeResponse;

/**
 * @author zhangruofan
 * @date 2018/11/14
 */
@AdvancedFeignClient
public interface RemoteChargeService {
    /**
     * 微信H5支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayWapChargeResponse
     * @throws BizException bizException
     */
    WxPayWapChargeResponse createWxPayWapCharge(WxPayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 微信公众号支付收单接口
     *
     * @param chargeRequest 支付请求
     * @return WxPayMpChargeResponse
     * @throws BizException bizException
     */
    WxPayMpChargeResponse createWxPayMpCharge(WxPayMpChargeRequest chargeRequest) throws BizException;

    /**
     * 发起支付宝手机网站支付请求
     *
     * @param chargeRequest 支付请求参数
     * @return response
     * @throws BizException bizException
     */
    AlipayWapChargeResponse createAlipayWapCharge(AlipayWapChargeRequest chargeRequest) throws BizException;

    /**
     * 查询支付订单详情
     *
     * @param orderNo 支付订单号
     * @return chargeOrderDto
     * @throws BizException bizException
     */
    ChargeOrderDto findByOrderNo(String orderNo) throws BizException;

    /**
     * 构造oauth2授权的url连接
     *
     * @param appId       兑吧appId
     * @param redirectURI 跳转的url
     * @return url
     * @throws BizException bizException
     */
    String oauth2buildAuthorizationUrl(Long appId, String redirectURI) throws BizException;

}
