package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.wxpay.WxPayChargeNotifyResponse;
import cn.com.duiba.paycenter.dto.payment.refund.wxpay.WxPayRefundNotifyResponse;

/**
 * @author zhangruofan
 * @date 2018/11/21
 */
@AdvancedFeignClient
public interface RemoteWxPayNotifyService {
    /**
     * 支付订单异步通知接口
     *
     * @param xmlData 微信返回的xml
     * @return WxPayChargeNotifyResponse
     * @throws BizException bizException
     */
    WxPayChargeNotifyResponse orderNotify(String xmlData) throws BizException;

    /**
     * 退款结果异步通知处理接口
     * @param xmlData 微信返回的xml
     * @return 支付中心的处理结果
     * @throws BizException 业务异常
     */
    WxPayRefundNotifyResponse refundNotify(String xmlData) throws BizException;
}
