package cn.com.duiba.paycenter.dto.payment.charge.ccb;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author shenengang
 * @date 2019/9/2 19:24
 */
public class CcbWapChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = 424292374164692626L;

    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 商户柜台代码
     * 区分钱支付到哪个供应商
     */
    private String posId;

    /**
     * 传给建行
     * 建行回传
     */
    private String remark1;

    /**
     * 传给建行
     * 建行回传
     */
    private String remark2;

    public String getRemark1() {
        return remark1;
    }

    public void setRemark1(String remark1) {
        this.remark1 = remark1;
    }

    public String getRemark2() {
        return remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getPosId() {
        return posId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

}
