package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSONObject;

/**
 * @author zhangruofan
 * @date 2018/11/20
 */
public class WxPayMpChargeResponse extends BaseChargeResponse {
    private static final long serialVersionUID = 2619012107394149631L;
    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;
    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;
    /**
     * 随机字符串
     */
    private String nonceStr;
    /**
     * 公众号id
     */
    private String appId;
    /**
     * 签名类型需要和下单一致
     */
    private String signType;
    /**
     * 签名
     */
    private String paySign;
    private Integer channelMode;
    private String mchId;
    private String wxAppId;

    public String getWxAppId() {
        return wxAppId;
    }

    public void setWxAppId(String wxAppId) {
        this.wxAppId = wxAppId;
    }

    public Integer getChannelMode() {
        return channelMode;
    }

    public void setChannelMode(Integer channelMode) {
        this.channelMode = channelMode;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public Long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }

    @Override
    public String getExtra() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channelMode", getChannelMode());
        jsonObject.put("mchId", getMchId());
        jsonObject.put("wxAppId", getAppId());

        return jsonObject.toJSONString();
    }
}
