package cn.com.duiba.paycenter.util;

/**
 * Created by xiaoxuda on 2018/6/22.
 */
public enum RedisKeyFactory {
    K001("支付宝APP_ID"),
    K002("app微信渠道配置"),
    K003("公众号id和商户号的微信渠道配置"),
	K004("支付宝渠道配置"),
    K005("支付宝app维度渠道配置"),
    K006("创建开发者应用账户 分布式锁"),
    ;
    private static final String SPACE = "PayCenter";
    private static final String SEPARATOR = "_";
	
    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return "PayCenter_" + this.name() + "_";
    }
}
