package cn.com.duiba.paycenter.dto.payment.charge.abc;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author liukai
 * @date 2019/10/12 19:24
 */
public class AbcWapChargeRequest extends BaseChargeRequest {

    private static final long serialVersionUID = 5376220406829390159L;
    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 订单时间 yyyy/MM/DD HH:MM:SS
     */
    @NotNull(message = "订单时间不能为空")
    private String createDate;

    /**
     * 支付结果通知的地址，不传则走默认配置
     */
    private String resultNotifyUrl;


    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getResultNotifyUrl() {
        return resultNotifyUrl;
    }

    public void setResultNotifyUrl(String resultNotifyUrl) {
        this.resultNotifyUrl = resultNotifyUrl;
    }
}
