package cn.com.duiba.paycenter.dto.payment.charge.cmb;

import java.io.Serializable;

/**
 * @program: pay-center
 * @description: 招行一网通退款响应体 - rspData
 * @author: Simba
 * @create: 2019-09-27 16:36
 **/
public class RefundResponseRspDataBean implements Serializable {

    private static final long serialVersionUID = -7311333135247161790L;
    /**
     * 处理结果,SUC0000：请求处理成功
     * 其他：请求处理失败
     */
    private String rspCode;
    /**
     * 详细信息,请求处理失败时返回错误描述
     */
    private String rspMsg;
    /**
     * 响应时间,银行返回该数据的时间
     * 格式：yyyyMMddHHmmss
     */
    private String dateTime;
    /**
     * 银行的退款流水号
     */
    private String bankSerialNo;
    /**
     * 退款币种,固定为：“10”
     */
    private String currency;
    /**
     * 退款金额,格式：xxxx.xx
     */
    private String amount;
    /**
     * 银行的退款参考号
     */
    private String refundRefNo;
    /**
     * 退款受理日期
     * 格式：yyyyMMdd
     */
    private String bankDate;
    /**
     * 退款受理时间
     * 格式：HHmmss
     */
    private String bankTime;
    /**
     * 商户上送流水号
     */
    private String refundSerialNo;
    /**
     * 实际退款金额,格式：xxxx.xx
     */
    private String settleAmount;
    /**
     * 退回优惠金额,格式：xxxx.xx
     */
    private String discountAmount;

    public String getRspCode() {
        return rspCode;
    }

    public void setRspCode(String rspCode) {
        this.rspCode = rspCode;
    }

    public String getRspMsg() {
        return rspMsg;
    }

    public void setRspMsg(String rspMsg) {
        this.rspMsg = rspMsg;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getBankSerialNo() {
        return bankSerialNo;
    }

    public void setBankSerialNo(String bankSerialNo) {
        this.bankSerialNo = bankSerialNo;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getRefundRefNo() {
        return refundRefNo;
    }

    public void setRefundRefNo(String refundRefNo) {
        this.refundRefNo = refundRefNo;
    }

    public String getBankDate() {
        return bankDate;
    }

    public void setBankDate(String bankDate) {
        this.bankDate = bankDate;
    }

    public String getBankTime() {
        return bankTime;
    }

    public void setBankTime(String bankTime) {
        this.bankTime = bankTime;
    }

    public String getRefundSerialNo() {
        return refundSerialNo;
    }

    public void setRefundSerialNo(String refundSerialNo) {
        this.refundSerialNo = refundSerialNo;
    }

    public String getSettleAmount() {
        return settleAmount;
    }

    public void setSettleAmount(String settleAmount) {
        this.settleAmount = settleAmount;
    }

    public String getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }
}

