/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.paycenter.enums.duibaaccount;

import java.util.Arrays;
import java.util.Objects;

public enum PayTypeEnum {
    ALIPAY(1, "\u652f\u4ed8\u5b9d"),
    WECHAT(2, "\u5fae\u4fe1"),
    BANK(3, "\u94f6\u884c\u5361");

    private Integer code;
    private String desc;

    private PayTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static String getDescByCode(Integer code) {
        if (Objects.isNull(code)) {
            return "";
        }
        PayTypeEnum payTypeEnum = PayTypeEnum.getByCode(code);
        if (Objects.nonNull((Object)payTypeEnum)) {
            return payTypeEnum.getDesc();
        }
        return "";
    }

    public static PayTypeEnum getByCode(Integer code) {
        return Arrays.stream(PayTypeEnum.values()).filter(a -> a.code.equals(code)).findFirst().orElse(null);
    }

    public static boolean isExist(Integer code) {
        return Objects.nonNull(code) && Arrays.stream(PayTypeEnum.values()).anyMatch(a -> a.code.equals(code));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

