package cn.com.duiba.paycenter.enums;

import org.apache.commons.lang.StringUtils;

import java.util.Arrays;

/**
 * 支付渠道枚举
 * @author zhangruofan
 * @date 2018/11/05
 */
public enum ChannelEnum {
    /**
     * 支付宝APP支付
     */
    ALIPAY("alipay", "支付宝APP支付"),
    /**
     * 支付宝手机网站支付
     */
    ALIPAY_WAP("alipay_wap", "支付宝手机网站支付"),
    /**
     * 支付宝扫码支付
     */
    ALIPAY_QR("alipay_qr", "支付宝扫码支付"),
    /**
     * 支付宝网站支付
     */
    ALIPAY_PC("alipay_pc", "支付宝电脑网站支付"),
    /**
     * 微信APP支付
     */
    WX("wx", "微信APP支付"),
    /**
     * 微信公众号支付
     */
    WX_PUB("wx_pub", "微信公众号支付"),
    /**
     * 微信扫码支付
     */
    WX_PUB_QR("wx_pub_qr", "微信扫码支付"),
    /**
     * 微信H5支付
     */
    WX_WAP("wx_wap", "微信H5支付"),
    /**
     * 微信小程序支付
     */
    WX_LITE("wx_lite", "微信小程序支付"),
    /**
     * 微信现金红包
     */
    WX_RED_PACKET("wx_red_packet", "微信现金红包"),
    /**
     * 连连个人支付
     */
    LIANLIAN_PERSONAL("lianlian_personal", "连连个人支付"),
    /**
     * 连连企业支付
     */
    LIANLIAN_ENTERPRISE("lianlian_enterprise", "连连企业支付"),

    BANK_OF_SUZHOU_WAP("bank_of_suzhou_wap", "苏州银行"),

    WJRCB_WX_PUB("wjrcb_wx_pub", "苏州农商户微信公众号支付"),

    BANK_OF_CCB_PAY("bank_of_ccb_wap", "建设银行"),

    BANK_OF_ABC_PAY("bank_of_abc_wap", "农业银行"),

    BANK_OF_CITIC_PAY("bank_of_citic_wap", "中信银行"),

    BANK_OF_BOC_PAY("bank_of_boc_wap", "中国银行"),

    BANK_OF_ICBC_PAY_H5("bank_of_icbc_h5", "工行e支付H5"),

    HELLO_PAY("hellopay", "哈啰支付"),
    SHOUXIN_PAY("shouxinpay", "首信支付"),

    MOCK_PAY("mockpay", "Mock支付"),


    /**
     * 招商银行一网通支付（OneNetPay）
     */
    ONE_NET_PAY_OF_CMB("one_net_pay_of_cmb", "招商银行一网通支付"),

    /**
     * 客集集微信小程序支付
     */
    WX_LITE_KEJIJI("wx_lite_kejiji", "客集集微信小程序支付 - 客集集"),

    UNION_PAY("unionpay", "银联云闪付"),

    WX_COUPON("wxcoupon", "微信优惠券"),

    BANK_OF_CEB_XYK_PAY("bank_of_ceb_xyk_pay", "中国光大银行信用卡中信支付"),

    DUIBA_LIVE_MP_PAY("duiba_live_mp_pay", "兑吧直播小程序支付"),

    DUIBA_LIVE_INSTALLMENT_PAY("duiba_live_installment_pay", "兑吧直播分期支付"),

    ;

    private String channelType;
    private String channelName;

    ChannelEnum(String channelType, String channelName) {
        this.channelType = channelType;
        this.channelName = channelName;
    }

    public String getChannelType() {
        return channelType;
    }

    public String getChannelName() {
        return channelName;
    }

    public static String getChannelName(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return null;
        }
        if (isActive(channelType)) {
            return ChannelEnum.valueOf(channelType).channelName;
        }
        return null;
    }

    /**
     * 返回channelId是否有效
     * @param channelType 渠道
     * @return 是否有效
     */
    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank(channelType)) {
            return false;
        }
        return Arrays.stream(ChannelEnum.values())
                .anyMatch(channelEnum -> channelEnum.channelType.equals(channelType));
    }
}
