package cn.com.duiba.paycenter.dto.payment.charge.ecarx;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * Created by sunyan on 2019/10/24.
 */
public class EcarxChargeRequest extends BaseChargeRequest{

    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;
    /**
     * 开发者用户id
     */
    @NotNull(message = "开发者用户id不能为空")
    private String uid;
    /**
     * 亿咖通订单号
     */
    @NotNull(message = "亿咖通订单号不能为空")
    private String ecarxOrderId;

    public String getEcarxOrderId() {
        return ecarxOrderId;
    }

    public void setEcarxOrderId(String ecarxOrderId) {
        this.ecarxOrderId = ecarxOrderId;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }
}
