package cn.com.duiba.paycenter.dto.payment.charge.ecarx;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;
import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;
import com.alibaba.fastjson.JSONObject;

import javax.validation.constraints.NotNull;

/**
 *cmm
 * 亿咖通小程序支付响应类
 */
public class EcarxChargeResponse extends BaseChargeResponse {
    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;
    /**
     * 时间戳精确到秒
     */
    private Long timeStamp;
    /**
     * 随机字符串
     */
    private String nonceStr;
    /**
     * 公众号id
     */
    private String appId;
    /**
     * 签名类型需要和下单一致
     */
    private String signType;
    /**
     * 签名
     */
    private String paySign;
    private Integer channelMode;
    private String mchId;
    private String wxAppId;

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public Long getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }

    public Integer getChannelMode() {
        return channelMode;
    }

    public void setChannelMode(Integer channelMode) {
        this.channelMode = channelMode;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getWxAppId() {
        return wxAppId;
    }

    public void setWxAppId(String wxAppId) {
        this.wxAppId = wxAppId;
    }

    @Override
    public String getExtra() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("channelMode", getChannelMode());
        jsonObject.put("wxAppId", getAppId());
        jsonObject.put("mchId", getMchId());

        return jsonObject.toJSONString();
    }

}
