package cn.com.duiba.paycenter.dto.payment.charge.shouxin;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 *
 * @author sunyan
 * @date 2019/11/21
 */
public class ShouxinPayChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = -3165829619285995983L;
    /**
     * 开发者用户id
     */
    @NotNull(message = "开发者用户id不能为空")
    private String uid;

    /**
     * 异步跳转地址(包含域名)
     */
    @NotNull(message = "异步通知url不能为空")
    private String notifyUrl;

    /**
     * 同步跳转地址(包含域名)
     */
    @NotNull(message = "支付结果返回URL不能为空")
    private String returnUrl;

    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 订单描述
     */
    @NotNull(message = "订单描述不能为空")
    @Size(max = 128, message = "订单描述超过128")
    private String desc;

    /**
     * 商品id
     */
    @NotNull(message = "商品id不能为空")
    private Long appItemId;

    public String getReturnUrl() {
        return returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }
}
