package cn.com.duiba.paycenter.dto.payment.charge.ningboBank;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Date;

/**
 * @author fja
 */
public class ChargeApiRespData {

    private static final String CHARGE_SUCCESS_CODE = "00";

    private static final String CHARGE_FAIL_CODE = "01";

    /**
     * 商户系统交易流水号
     */
    private String merApplySeqNo;

    /**
     * 商户交易时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date merApplyDateTime;

    /**
     * 返回Token用于支付
     */
    private String transApplyToken;

    /**
     * 支付中心交易日期
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date transApplyDateTime;

    /**
     * 订单描述
     */
    private String orderDesc;

    /**
     * 返回信息
     */
    private String msg;

    /**
     * 唤起收银台地址
     */
    private String gwPayPageUrl;

    /**
     * 唤起收银台安全参数
     */
    private String gwRedirectParams;

    /**
     * 申请支付状态
     * {@link ChargeApiRespData#CHARGE_SUCCESS_CODE}
     * {@link ChargeApiRespData#CHARGE_FAIL_CODE}
     */
    private String applyStatus;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 错误响应码
     */
    private String errorCode;


    public boolean isSuccess() {
        return CHARGE_SUCCESS_CODE.equals(this.applyStatus);
    }

    public String getMerApplySeqNo() {
        return merApplySeqNo;
    }

    public void setMerApplySeqNo(String merApplySeqNo) {
        this.merApplySeqNo = merApplySeqNo;
    }

    public Date getMerApplyDateTime() {
        return merApplyDateTime;
    }

    public void setMerApplyDateTime(Date merApplyDateTime) {
        this.merApplyDateTime = merApplyDateTime;
    }

    public String getTransApplyToken() {
        return transApplyToken;
    }

    public void setTransApplyToken(String transApplyToken) {
        this.transApplyToken = transApplyToken;
    }

    public Date getTransApplyDateTime() {
        return transApplyDateTime;
    }

    public void setTransApplyDateTime(Date transApplyDateTime) {
        this.transApplyDateTime = transApplyDateTime;
    }

    public String getOrderDesc() {
        return orderDesc;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getGwPayPageUrl() {
        return gwPayPageUrl;
    }

    public void setGwPayPageUrl(String gwPayPageUrl) {
        this.gwPayPageUrl = gwPayPageUrl;
    }

    public String getGwRedirectParams() {
        return gwRedirectParams;
    }

    public void setGwRedirectParams(String gwRedirectParams) {
        this.gwRedirectParams = gwRedirectParams;
    }

    public String getApplyStatus() {
        return applyStatus;
    }

    public void setApplyStatus(String applyStatus) {
        this.applyStatus = applyStatus;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}
