package cn.com.duiba.paycenter.dto.payment.charge.ningboBank.charge;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.Date;

/**
 * 宁波银行下单业务实体类
 *
 * @author fja
 * @date 2022-03-12
 */
public class NbcbChargeBizData {
    /**
     * 商户系统编号 默认NBCB999999999
     */
    private String platformId;

    /**
     * 商户号
     */
    @JSONField(name = "merId")
    private String merchantId;

    /**
     * 商户系统交易流水号
     */
    @JSONField(name = "merSeqNo")
    private String orderNo;

    /**
     * 商户交易时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date merDateTime;

    /**
     * 币种
     */
    private String currency;

    /**
     * 交易金额 以元为单位
     */
    private String transAmt;

    /**
     * 如果行方有立减活动
     * totalAmt = transAmt + 立减金额
     */
    private String totalAmt;

    /**
     * 渠道类型
     * 00-默认 01-手机银行 02-网银 03-本次接入商户
     */
    private String channelType = "00";

    /**
     * 后台通知地址
     */
    private String notifyUrl;

    /**
     * 进入支付页后跳转回商户的地址，不传的话，可能无法返回。
     */
    private String payFrontUrl;

    /**
     * 支付完成或失败后跳转回商户的地址
     */
    private String paySuccessUrl;

    /**
     * 支付页返回标题
     */
    private String payFrontTitle;

    /**
     * 充值类型 由宁波银行提供
     */
    private String rechargeType;

    /**
     * 订单描述
     */
    private String orderDesc;

    /**
     * 宁波银行 当前场景只有手机端
     */
    private String terminalType = "02";


    public String getPlatformId() {
        return platformId;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Date getMerDateTime() {
        return merDateTime;
    }

    public void setMerDateTime(Date merDateTime) {
        this.merDateTime = merDateTime;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getTransAmt() {
        return transAmt;
    }

    public void setTransAmt(String transAmt) {
        this.transAmt = transAmt;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getPayFrontUrl() {
        return payFrontUrl;
    }

    public void setPayFrontUrl(String payFrontUrl) {
        this.payFrontUrl = payFrontUrl;
    }

    public String getPayFrontTitle() {
        return payFrontTitle;
    }

    public void setPayFrontTitle(String payFrontTitle) {
        this.payFrontTitle = payFrontTitle;
    }

    public String getRechargeType() {
        return rechargeType;
    }

    public void setRechargeType(String rechargeType) {
        this.rechargeType = rechargeType;
    }

    public String getOrderDesc() {
        return orderDesc;
    }

    public void setOrderDesc(String orderDesc) {
        this.orderDesc = orderDesc;
    }

    public String getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getTotalAmt() {
        return totalAmt;
    }

    public void setTotalAmt(String totalAmt) {
        this.totalAmt = totalAmt;
    }

    public String getPaySuccessUrl() {
        return paySuccessUrl;
    }

    public void setPaySuccessUrl(String paySuccessUrl) {
        this.paySuccessUrl = paySuccessUrl;
    }
}
