package cn.com.duiba.paycenter.dto.payment.charge.ningboBank.charge;


import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;

/**
 * @author fja
 */
public class NbcbChargeResponseDto extends BaseChargeResponse {

    /**
     * 收银台地址
     */
    private String payGateWayUrl;

    private NbcbChargeResponseDto() {

    }

    public static NbcbChargeResponseDto fail(String message) {
        NbcbChargeResponseDto resp = new NbcbChargeResponseDto();
        resp.setSuccess(false);
        resp.setMessage(message);
        return resp;
    }


    public static NbcbChargeResponseDto success(String orderNo, String payGateWayUrl) {
        NbcbChargeResponseDto resp = new NbcbChargeResponseDto();
        resp.setSuccess(true);
        resp.setOrderNo(orderNo);
        //收银台地址
        resp.setPayGateWayUrl(payGateWayUrl);
        return resp;
    }

    @Override
    public String getExtra() {
        return null;
    }


    public String getPayGateWayUrl() {
        return payGateWayUrl;
    }

    public void setPayGateWayUrl(String payGateWayUrl) {
        this.payGateWayUrl = payGateWayUrl;
    }
}
