package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.ningbobank.notify.NbcbOrderNotifyRequestDto;
import cn.com.duiba.paycenter.dto.payment.charge.ningbobank.notify.NbcbPayNotifyResponseDto;
import cn.com.duiba.paycenter.dto.payment.charge.ningbobank.notify.NbcbRefundNotifyResponseDto;

/**
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteNingboNotifyService {
    /**
     * 支付通知
     *
     * @param requestDto 订单通知请求
     * @return 通知响应
     */
    NbcbPayNotifyResponseDto payNotify(NbcbOrderNotifyRequestDto requestDto);

    /**
     * 退款支付
     *
     * @param requestDto 订单通知请求
     * @return 通知响应
     */
    NbcbRefundNotifyResponseDto refundNotify(NbcbOrderNotifyRequestDto requestDto);
}
