package cn.com.duiba.paycenter.remoteservice.payment;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.paycenter.dto.payment.charge.qingdaobank.*;
import cn.com.duiba.paycenter.dto.payment.charge.shouxin.ShouxinPayChargeNotifyRequest;
import cn.com.duiba.paycenter.dto.payment.charge.shouxin.ShouxinPayChargeNotifyResponse;
import cn.com.duiba.paycenter.dto.payment.refund.qingdaobank.QingdaoBankPayRefundRequest;
import cn.com.duiba.paycenter.dto.payment.refund.shouxin.ShouxinPayRefundNotifyRequest;
import cn.com.duiba.paycenter.dto.payment.refund.shouxin.ShouxinPayRefundNotifyResponse;

import java.util.List;
import java.util.Set;

/**
 *
 * @author zzh
 * @date 2019/11/21
 */
@AdvancedFeignClient
public interface RemoteQingdaoBankPayService {
    /**
     * 青岛银行支付通知
     * @param qingdaoBankPayNotifyRequest
     * @return response
     * @throws BizException exception
     */
    QingdaoBankPayChargeNotifyResponse orderNotify(QingdaoBankPayNotifyRequest qingdaoBankPayNotifyRequest) throws BizException;

    /**
     * 青岛银行退款通知
     * @param qingdaoBankPayNotifyRequest
     * @return response
     * @throws BizException exception
     */
    QingdaoBankPayRefundNotifyResponse refundNotify(QingdaoBankPayNotifyRequest qingdaoBankPayNotifyRequest);


    /**
     * 支付 上游订单状态批量查询
     * @param orderNos 支付订单号
     * @return
     */
    List<QingdaoBankPayOrderInfoResponse> payOrdersInfoQuery(List<String> orderNos);
    /**
     * 退款 上游订单状态批量查询
     * @param orderNos 退款订单号
     * @return
     */
    List<QingdaoBankPayOrderInfoResponse> refundOrdersInfoQuery(List<String> orderNos);

    /**
     *  青岛银行开发者ids 同步订单
     * @return
     */
    Set<Long> qingdaoBankDeveloperIds();





}
