package cn.com.duiba.paycenter.dto.payment.charge;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhangruofan
 * @date 2018/11/13
 */
public class ChargeOrderDto implements Serializable {
    private static final long serialVersionUID = 729193730566782090L;
    /**
     * 支付订单号
     */
    private String orderNo;
    /**
     * 支付金额，单位为分
     */
    private Integer amount;
    /**
     * 上游调用方的订单号
     */
    private String bizOrderNo;
    /**
     * 分配给业务方的类型和bizOrderNo配合使用
     * bizType + bizOrderNo 保证唯一
     * @see cn.com.duiba.paycenter.enums.BizTypeEnum
     */
    private Integer bizType;
    /**
     * 支付渠道
     * @see cn.com.duiba.paycenter.enums.ChannelEnum
     */
    private String channelType;
    /**
     * 客户端ip地址，支持ipv6
     * 获取用户真实ip
     * @link https://pay.weixin.qq.com/wiki/doc/api/H5_sl.php?chapter=15_5
     */
    private String clientIp;
    /**
     * 终端设备信息
     * 可以不传
     */
    private String deviceInfo;
    /**
     * 兑吧appId
     */
    private Long appId;
    /**
     * 订单标题
     * 会传给第三方支付
     */
    private String subject;
    /**
     * 订单描述信息
     * 会传给第三方支付
     */
    private String body;
    /**
     * 支付过期时间
     * 默认30分钟
     * 最短失效时间间隔必须大于5分钟
     */
    private Date expireTime;
    /**
     * 渠道发起交易时需要的数据
     */
    private ChargeExtra extra;
    /**
     * 业务方查询需要的信息
     * 创建订单时自行放入，格式不做要求，业务方自行解析
     */
    private String metadata;
    /**
     * 渠道返回的交易流水号
     */
    private String transactionNo;
    /**
     * 渠道返回的错误码
     */
    private String failureCode;
    /**
     * 渠道返回的错误信息
     */
    private String failureMsg;
    /**
     * 支付状态
     * @see cn.com.duiba.paycenter.enums.ChargeOrderStatusEnum
     */
    private Integer chargeStatus;
    /**
     * 支付时间
     */
    private Date paidTime;

    private Date gmtCreate;
    private Date gmtModified;

    private String title;

    private String extraStr;

    public String getExtraStr() {
        return extraStr;
    }

    public void setExtraStr(String extraStr) {
        this.extraStr = extraStr;
    }

    public String getTransactionNo() {
        return transactionNo;
    }

    public void setTransactionNo(String transactionNo) {
        this.transactionNo = transactionNo;
    }

    public String getFailureCode() {
        return failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public String getFailureMsg() {
        return failureMsg;
    }

    public void setFailureMsg(String failureMsg) {
        this.failureMsg = failureMsg;
    }

    public Integer getChargeStatus() {
        return chargeStatus;
    }

    public void setChargeStatus(Integer chargeStatus) {
        this.chargeStatus = chargeStatus;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizOrderNo() {
        return bizOrderNo;
    }

    public void setBizOrderNo(String bizOrderNo) {
        this.bizOrderNo = bizOrderNo;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getChannelType() {
        return channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public ChargeExtra getExtra() {
        return extra;
    }

    public void setExtra(ChargeExtra extra) {
        this.extra = extra;
    }

    public String getMetadata() {
        return metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Date getPaidTime() {
        return paidTime;
    }

    public void setPaidTime(Date paidTime) {
        this.paidTime = paidTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
