package cn.com.duiba.paycenter.dto.payment.charge.wxpay;

import cn.com.duiba.api.enums.SubjectTypeEnum;
import cn.com.duiba.paycenter.constant.WxCouponSubjectEnum;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;


/**
 * 微信发放优惠券请求参数
 */
public class WxCouponSendRequest implements Serializable {


    private static final long serialVersionUID = -304154988971578334L;
    /**
     * 兑吧appId
     */
    @NotNull(message = "兑吧appId不能为空")
    private Long appId;

    /**
     * 业务主体类型 -- 必传参数
     *
     * @see SubjectTypeEnum#getType()
     */
    @NotBlank(message = "subjectType不能为空")
    private String subjectType;

    /**
     * 优惠券发放的用户id（需是在业务主体公众号对应的openId）
     *
     * 此 openId 归属于 上游APP的"业务主体"，而非上游业务APP
     */
    @NotBlank(message = "openId不能为空")
    private String openid;

    /**
     * 优惠券批次号-发放优惠券指定值
     */
    @NotBlank(message = "stockId不能为空")
    private String stockId;

    /**
     * 创建优惠券批次的商户号，如果发放开发者商户号优惠券，则填写开发者商户号
     * （发放其他商户优惠券需要需要开发者商户号开放相应权限)
     * @see：https://developers.weixin.qq.com/community/pay/doc/0000046f16862087608adcdf959c08
     * 若不填则表示发放自身商户的优惠券(现仅支持兑吧商户号)
     */
    private String stockCreatorMchid;

    /**
     * 业务方生成的订单id，需保持唯一性（请求到微信时会组装成 商户Id+{yyyyMMdd}+bizId）
     */
    @NotBlank(message = "bizId不能为空")
    private String bizId;

    /**
     *  微信立减金主体
     * @see WxCouponSubjectEnum
     */
    @NotNull(message = "微信立减金商户主体不能为空")
    private WxCouponSubjectEnum wxCouponSubject;

    /**
     * 公众账号id
     */
    private String wxAppId;

    /**
     * 微信立减金-面额
     */
    private Long wxCouponValue;

    /**
     * 微信立减金-发放门槛
     */
    private Long wxCouponMinimum;

    public WxCouponSubjectEnum getWxCouponSubject() {
        return wxCouponSubject;
    }

    public void setWxCouponSubject(WxCouponSubjectEnum wxCouponSubject) {
        this.wxCouponSubject = wxCouponSubject;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getSubjectType() {
        return subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getStockId() {
        return stockId;
    }

    public void setStockId(String stockId) {
        this.stockId = stockId;
    }

    public String getStockCreatorMchid() {
        return stockCreatorMchid;
    }

    public void setStockCreatorMchid(String stockCreatorMchid) {
        this.stockCreatorMchid = stockCreatorMchid;
    }

    public String getWxAppId() {
        return wxAppId;
    }

    public void setWxAppId(String wxAppId) {
        this.wxAppId = wxAppId;
    }

    public Long getWxCouponValue() {
        return wxCouponValue;
    }

    public void setWxCouponValue(Long wxCouponValue) {
        this.wxCouponValue = wxCouponValue;
    }

    public Long getWxCouponMinimum() {
        return wxCouponMinimum;
    }

    public void setWxCouponMinimum(Long wxCouponMinimum) {
        this.wxCouponMinimum = wxCouponMinimum;
    }
}
