package cn.com.duiba.paycenter.dto.payment.charge.cib;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeResponse;

/**
 * cib预支付响应
 *
 * @author zouwx
 * @date 2022/10/25
 */
public class CibPayWxChargeResponseDTO extends BaseChargeResponse {

    private static final long serialVersionUID = 2441683691080988178L;

    /**
     * 支付信息 用于唤起收银台
     */
    private String payInfo;


    @Override
    public String getExtra() {
        return null;
    }

    public String getPayInfo() {
        return payInfo;
    }

    public void setPayInfo(String payInfo) {
        this.payInfo = payInfo;
    }

    public static CibPayWxChargeResponseDTO fail(String message) {
        CibPayWxChargeResponseDTO resp = new CibPayWxChargeResponseDTO();
        resp.setSuccess(false);
        resp.setMessage(message);
        return resp;
    }


    public static CibPayWxChargeResponseDTO success(String orderNo, String payInfo) {
        CibPayWxChargeResponseDTO resp = new CibPayWxChargeResponseDTO();
        resp.setSuccess(true);
        resp.setOrderNo(orderNo);
        //收银台地址
        resp.setPayInfo(payInfo);
        return resp;
    }
}
