package cn.com.duiba.paycenter.dto.payment.charge.wjrcb;

import cn.com.duiba.paycenter.dto.payment.charge.BaseChargeRequest;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 苏州农商行支付请求
 * @author zhangruofan
 * @date 2019/07/25
 */
public class WjrcbPayWxPubChargeRequest extends BaseChargeRequest {
    private static final long serialVersionUID = 810042952629305229L;

    /**
     * client ip
     */
    private String ip;
    /**
     * wx open id
     */
    @NotNull(message = "open id 不能为空")
    private String openId;

    /**
     * 订单描述
     */
    @NotNull(message = "订单描述不能为空")
    @Size(max = 128, message = "订单描述超过128")
    private String desc;

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
